/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::   Module      :   Boot Interface definition for MPC55xx processor familiy
::   Copyright   :   (C)2006-2009 Woodward
::   Platform(s) :   MPC55xx
::   Limitations :   This file is designed to be included by BootInterface.h
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
/*! \internal
    \file  BootInterface_MPC55xx.h

*/
#ifndef __BOOTINTERFACE_MPC55XX_H
#define __BOOTINTERFACE_MPC55XX_H

/*---- INCLUDE FILES --------------------------------------------------------------------------------------*/

/*---- DEFINES --------------------------------------------------------------------------------------------*/
/*! \brief Defines the start address of a MotoTron boot application as an unsigned integer */
#define MOTOTRON_HARDBOOT_BASE_ADDR (0x4000UL)
/*! \brief Defines the size the memory region that has been reserved for the MotoTron boot app */
#define MOTOTRON_HARDBOOT_BLOCK_BYTESIZE (48 * 1024)

/*! \brief Defines the start address of a MotoTron application as an unsigned integer */
#define MOTOTRON_APPLICATION_BLOCK_START     0x40000UL
/*! \brief Defines the size the memory region that has been reserved for the MotoTron application */
#define MOTOTRON_APPLICATION_BLOCK_BYTESIZE  (48 * 1024)

/*! \brief Defines the start address of a MotoTron Customer specific boot application as an unsigned integer */
#define MOTOTRON_CUSTOMERBOOT_BLOCK_START    0x10000UL
/*! \brief Defines the size the memory region that has been reserved for the MotoTron Customer specific boot app */
#define MOTOTRON_CUSTOMERBOOT_BLOCK_BYTESIZE (48 * 1024)

/*! \brief Defines the start address of an ECM Vendor specific boot application as an unsigned integer */
#define ECMVENDOR_BOOT_BLOCK_START           0x1C000UL
/*! \brief Defines the size the memory region that has been reserved for the ECM Vendor specific boot application */
#define ECMVENDOR_BOOT_BLOCK_BYTESIZE        (16 * 1024)

/*! \brief Macro to return a pointer to an array of Module Configuration Pointers */
#define GetModuleConfigPointerArr()       ((BASEPTRARR)0x010)
/*! \brief Macro to return a pointer to an array of Hardware BootStrap Pointers */
#define GetHardwareBootStrapPointerArr()  ((BASEPTRARR)0x4010)
/*! \brief Macro to return a pointer to the boot mail box */
#define GetBootMailBox()                  ((S_BootMailBox*)0x4000FFF0)

/*! \brief MPC55xx memory model is such that the Entry vector can always be determined and can be done so
           without needing to resort to the pointers for the defined (though this scheme could still be used */
#define BootInterface_EntryVector_GetPtr(uBlockStart)       ((PFNENTRYPOINT *)(uBlockStart + 4))

#define BootInterface_CRCBlockDefnPtr_GetPtr(uBlockStart) ((S_CRCBlock const* const*)(uBlockStart + 8))

#define BootInterface_RAMLoaderPointerArr_GetPtr() ((BASEPTRARR)0x40000010)

/*---- TYPEDEF --------------------------------------------------------------------------------------------*/

/*---- FUNCTION PROTOTYPES --------------------------------------------------------------------------------*/

#endif /* __BOOTINTERFACE_MPC55XX_H */


/*---- END OF FILE ----------------------------------------------------------------------------------------*/

